import React from 'react'
import Link from 'next/link';
import Image from 'next/image';

const Halfyearlyreport = ({ halfreport }) => {
    if (!halfreport || !halfreport.file_name || !halfreport.title) {
        return <div>Error: Invalid half report data</div>;
    }

    return (
        <div className='pdfsspacers text-center bg-white p-2 border rounded-3'>
            <Link target='_blank' href={halfreport.file_name}>
                <Image src='/assets/pdficon.png' className='img-fluid p-4' alt="" width={416} height={227} layout='responsive' />
                <p>{halfreport.title}</p>
            </Link>
        </div>
    )
}

export default Halfyearlyreport;
